

<?php $__env->startSection('title', 'Time Sheet- Canindigo INC'); ?>
<?php $__env->startSection('page-title', 'My Time Sheets'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-lg shadow">
    <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
            <h3 class="text-lg font-medium text-gray-900">Time Sheet Summary</h3>
            <a href="<?php echo e(route('time-sheets.create')); ?>" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 flex items-center">
            Add New Entry
            </a>
            </div>

            <div class="mt-2 grid grid-cols-1 md:grid-cols-3 gap-4">
                <div class="bg-blue-50 p-4 rounded-lg">
                    <p class="text-sm font-medium text-blue-800">Total Regular Hours</p>
                    <p class="text-2xl font-bold text-blue-900"><?php echo e($totalRegularHours ?? 0); ?> hrs</p>
                </div>
                <div class="bg-orange-50 p-4 rounded-lg">
                    <p class="text-sm font-medium text-orange-800">Total Overtime Hours</p>
                    <p class="text-2xl font-bold text-orange-900"><?php echo e(($totalOvertimeWeekdays ?? 0) + ($totalOvertimeWeekend ?? 0)); ?> hrs</p>
                </div>
                <div class="bg-green-50 p-4 rounded-lg">
                    <p class="text-sm font-medium text-green-800">Total Hours Worked With (OT)</p>
                    <p class="text-2xl font-bold text-green-900"><?php echo e($totalAllHours ?? 0); ?> hrs</p>
                </div>
            </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">DATE</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">TIME</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">TOTAL HOURS</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">OT WEEKDAYS</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">OT WEEKEND</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">TOTAL WITH OT</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ACTIONS</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $timesheets ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timesheet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        // Calculate hours for each row
                        $start = \Carbon\Carbon::parse($timesheet->start_time);
                        $end = \Carbon\Carbon::parse($timesheet->end_time);
                        $regularHours =- round($end->diffInMinutes($start) / 60, 2);
                        $totalWithOT = $regularHours + ($timesheet->overtime_weekdays ?? 0) + ($timesheet->overtime_weekend ?? 0);
                    ?>
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-gray-900"><?php echo e($timesheet->date->format('M d, Y')); ?></div>
                            <div class="text-sm text-gray-500"><?php echo e($timesheet->date->format('l')); ?></div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900">
                                <?php echo e(date('g:i A', strtotime($timesheet->start_time))); ?> - <?php echo e(date('g:i A', strtotime($timesheet->end_time))); ?>

                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-1000">
                                <?php echo e($regularHours); ?> hrs
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-green-1000">
                               <?php echo e($timesheet->overtime_weekdays ?? 0); ?> hrs
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-100 text-green-1000">
                               <?php echo e($timesheet->overtime_weekend ?? 0); ?> hrs
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-green-1000">
                                <?php echo e($totalWithOT); ?> hrs
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <a href="<?php echo e(route('time-sheets.show', $timesheet)); ?>" class="text-blue-600 hover:text-blue-900 mr-3">View</a>
                            <!-- <a href="<?php echo e(route('time-sheets.edit', $timesheet)); ?>" class="text-green-600 hover:text-green-900 mr-3">Edit</a> -->
                            <form action="<?php echo e(route('time-sheets.destroy', $timesheet)); ?>" method="POST" class="inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="text-red-600 hover:text-red-900" onclick="return confirm('Are you sure?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="px-6 py-4 text-center text-sm text-gray-500">
                            No timesheet entries found.
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
                <?php if(isset($timesheets) && $timesheets->count() > 0): ?>
                <tfoot class="bg-gray-20">
                    <tr>
                        <td colspan="2" class="px-6 py-4 text-sm font-medium text-gray-900 text-right">Totals:</td>
                        <td class="px-6 py-4 text-sm font-bold text-gray-1000"><?php echo e($totalRegularHours ?? 0); ?> hrs</td>
                        <td class="px-6 py-4 text-sm font-bold text-gray-1000"><?php echo e($totalOvertimeWeekdays ?? 0); ?> hrs</td>
                        <td class="px-6 py-4 text-sm font-bold text-gray-1000"><?php echo e($totalOvertimeWeekend ?? 0); ?> hrs</td>
                        <td class="px-6 py-4 text-sm font-bold text-gray-1000"><?php echo e($totalAllHours ?? 0); ?> hrs</td>
                        <td class="px-6 py-4"></td>
                    </tr>
                </tfoot>
                <?php endif; ?>
            </table>
        </div>
    </div>

    <!-- <div class="mt-6">
        <a href="<?php echo e(route('time-sheets.create')); ?>" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-200">
            Add New Entry
        </a>
    </div> -->
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\Scratch\resources\views/time-sheets/index.blade.php ENDPATH**/ ?>