

<?php $__env->startSection('title', 'Vehicle Usage- Canindigo INC'); ?>
<?php $__env->startSection('page-title', 'Vehicle Usage Management'); ?>

<?php $__env->startSection('content'); ?>
<?php if(session('success')): ?>
    <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
        <?php echo e(session('success')); ?>

    </div>
<?php endif; ?>
<div class="bg-white rounded-lg shadow">
    <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
        <h3 class="text-lg font-medium text-gray-900">Vehicle Usage Records</h3>
        <a href="<?php echo e(route('vehicle-usage.create')); ?>" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 flex items-center">
            <i class="fas fa-plus mr-2"></i> Add New Record
        </a>
    </div>
        <div class="mt-2 grid grid-cols-1 md:grid-cols-2 gap-4">
            <div class="bg-blue-50 p-5 rounded-lg">
                <p class="text-sm font-medium text-blue-800">Total Vehicle Used</p>
                <p class="text-2xl font-bold text-blue-900"><?php echo e($vehicleUsages->count() ?? 0); ?> Vehicles</p>
            </div>
            <div class="bg-orange-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-orange-800">Total Distance</p>
                <p class="text-2xl font-bold text-orange-900"><?php echo e($totalKilometers ?? 0); ?> km</p>
            </div>
            <!-- <div class="bg-green-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-green-800">Total Hours Worked With (OT)</p>
                <p class="text-2xl font-bold text-green-900"><?php echo e($totalAllHours ?? 0); ?> hrs</p>
            </div> -->
        </div>
    <div class="p-6">
        

        <?php if($vehicleUsages->count() > 0): ?>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Vehicle</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Distance</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Fuel Used</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Efficiency</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Purpose</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $vehicleUsages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-gray-900"><?php echo e($usage->date->format('M d, Y')); ?></div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-gray-900"><?php echo e($usage->vehicle->registration_number); ?></div>
                            <div class="text-sm text-gray-500"><?php echo e($usage->vehicle->model); ?></div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-1000">
                                <?php echo e($usage->distance); ?> km
                            </span>                                
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-green-1000">
                                <?php echo e($usage->fuel_consumption); ?> L
                            </span>
                           
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-100 text-green-1000">
                               <?php echo e(number_format($usage->fuel_efficiency, 2)); ?> km/L
                            </span>
                            
                        </td>
                        <td class="px-6 py-4">
                            <div class="font-medium text-gray-900 truncate max-w-xs"><?php echo e(Str::limit($usage->trip_purpose, 30)); ?></div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <a href="<?php echo e(route('vehicle-usage.show', $usage)); ?>" class="text-blue-600 hover:text-blue-900 mr-3">View</a>
                            <!-- <a href="<?php echo e(route('vehicle-usage.edit', $usage)); ?>" class="text-green-600 hover:text-green-900 mr-3">Edit</a> -->
                            <form action="<?php echo e(route('vehicle-usage.destroy', $usage)); ?>" method="POST" class="inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="text-red-600 hover:text-red-900" onclick="return confirm('Are you sure?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <!-- <?php if(isset($usage) && $usage->count() > 0): ?>
                <tfoot class="bg-gray-50">
                    <tr>
                        <td colspan="2" class="px-6 py-4 text-sm font-medium text-gray-900 text-right">Totals:</td>
                        <td class="px-6 py-4 text-sm font-bold text-gray-1000"><?php echo e($vehicleUsages->count() ?? 0); ?> Vehicles</td>
                        <td class="px-6 py-4 text-sm font-bold text-gray-1000"><?php echo e($totalKilometers ?? 0); ?> km</td>
                        <td class="px-6 py-4 text-sm font-bold text-gray-1000"><?php echo e(number_format($usage->fuel_efficiency, 2)); ?> km/L</td>
                        <td class="px-6 py-4 text-sm font-bold text-gray-1000"><?php echo e($totalAllHours ?? 0); ?> hrs</td>
                        <td class="px-6 py-4"></td>
                    </tr>
                </tfoot>
                <?php endif; ?> -->
            </table>
        </div>

        <!-- Pagination -->
        
        <?php else: ?>
        <div class="text-center py-8">
            <i class="fas fa-car text-gray-300 text-4xl mb-4"></i>
            <p class="text-gray-500 text-lg">No vehicle usage records found.</p>
            <p class="text-gray-400 text-sm mt-2">Add your first vehicle usage record to get started.</p>
            <a href="<?php echo e(route('vehicle-usage.create')); ?>" class="mt-4 inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-white hover:bg-blue-700">
                Add Vehicle Usage Record
            </a>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\Scratch\resources\views/vehicle-usage/index.blade.php ENDPATH**/ ?>