

<?php $__env->startSection('title', 'Vehicle Usage Details- Canindigo INC'); ?>
<?php $__env->startSection('page-title', 'Vehicle Usage Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-3xl mx-auto">
    <div class="bg-white rounded-lg shadow p-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <h4 class="text-sm font-medium text-gray-500">Vehicle</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900"><?php echo e($vehicleUsage->vehicle->registration_number ?? 'N/A'); ?></p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">User</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900"><?php echo e($vehicleUsage->user->name ?? 'N/A'); ?></p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Date</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900"><?php echo e($vehicleUsage->date->format('F d, Y')); ?></p>
                <p class="text-sm text-gray-500"><?php echo e($vehicleUsage->date->format('l')); ?></p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Trip Purpose</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900"><?php echo e($vehicleUsage->trip_purpose); ?></p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Start KM</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900"><?php echo e($vehicleUsage->start_km); ?> KM</p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">End KM</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900"><?php echo e($vehicleUsage->end_km); ?> KM</p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Total Distance</h4>
                <p class="mt-1 text-lg font-semibold text-blue-600">
                    <?php echo e($vehicleUsage->end_km - $vehicleUsage->start_km); ?> KM
                </p>
            </div>

            <?php if($vehicleUsage->fuel_consumption): ?>
            <div>
                <h4 class="text-sm font-medium text-gray-500">Fuel Consumption</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900"><?php echo e($vehicleUsage->fuel_consumption); ?> L</p>
            </div>
            <?php endif; ?>

            <?php if($vehicleUsage->receipt_path): ?>
            <div class="md:col-span-2">
                <h4 class="text-sm font-medium text-gray-500">Receipt</h4>
                <div class="mt-2">
                    <img src="<?php echo e(asset('storage/' . $vehicleUsage->receipt_path)); ?>" 
                         alt="Receipt" 
                         class="max-w-xs rounded-lg shadow-md border">
                    <div class="mt-2">
                        <a href="<?php echo e(asset('storage/' . $vehicleUsage->receipt_path)); ?>" 
                           target="_blank" 
                           class="text-blue-600 hover:text-blue-800 text-sm">
                            View Full Size
                        </a>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <div class="mt-6 flex justify-end space-x-3">
            <a href="<?php echo e(route('vehicle-usage.index')); ?>" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400 transition duration-200">
                Back to List
            </a>
            <a href="<?php echo e(route('vehicle-usage.edit', $vehicleUsage)); ?>" class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition duration-200">
                Edit Entry
            </a>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\Scratch\resources\views/vehicle-usage/show.blade.php ENDPATH**/ ?>