@extends('layouts.app')

@section('title', 'Add Vehicle Usage')
@section('page-title', 'Add Vehicle Usage Record')

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="bg-white rounded-lg shadow p-6">
        <form action="{{ route('vehicle-usage.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Vehicle Selection -->
                <div class="md:col-span-2">
                    <label for="vehicle_id" class="block text-sm font-medium text-gray-700">Vehicle *</label>
                    <select name="vehicle_id" id="vehicle_id" required
                            class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm p-2 focus:ring-blue-500 focus:border-blue-500">
                        <option value="">Select a vehicle</option>
                        @foreach($vehicles as $vehicle)
                        <option value="{{ $vehicle->id }}" 
                                data-current-km="{{ $vehicle->current_km }}"
                                {{ old('vehicle_id') == $vehicle->id ? 'selected' : '' }}>
                            {{ $vehicle->registration_number }} - {{ $vehicle->model }} (Current: {{ $vehicle->current_km }} km)
                        </option>
                        @endforeach
                    </select>
                    @error('vehicle_id')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Date -->
                <div>
                    <label for="date" class="block text-sm font-medium text-gray-700">Date *</label>
                    <input type="date" name="date" id="date" value="{{ old('date', date('Y-m-d')) }}" 
                           class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm p-2 focus:ring-blue-500 focus:border-blue-500" required>
                    @error('date')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Start KM -->
                <div>
                    <label for="start_km" class="block text-sm font-medium text-gray-700">Start KM *</label>
                    <input type="number" name="start_km" id="start_km"  value="{{ old('start_km') }}" step="0.01" min="0"
                           class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm p-2 focus:ring-blue-500 focus:border-blue-500" required>
                    @error('start_km')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- End KM -->
                <div>
                    <label for="end_km" class="block text-sm font-medium text-gray-700">End KM *</label>
                    <input type="number" name="end_km" id="end_km" value="{{ old('end_km') }}" step="0.01" min="0"
                           class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm p-2 focus:ring-blue-500 focus:border-blue-500" required>
                    @error('end_km')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Fuel Consumption -->
                <div>
                    <label for="fuel_consumption" class="block text-sm font-medium text-gray-700">Fuel Consumption (Liters) *</label>
                    <input type="number" name="fuel_consumption" id="fuel_consumption" value="{{ old('fuel_consumption') }}" step="0.01" min="0"
                           class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm p-2 focus:ring-blue-500 focus:border-blue-500" required>
                    @error('fuel_consumption')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Receipt Upload -->
                <div>
                    <label for="receipt" class="block text-sm font-medium text-gray-700">Upload Receipt</label>
                    <input type="file" name="receipt" id="receipt" 
                           class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm p-2 focus:ring-blue-500 focus:border-blue-500"
                           accept=".jpg,.jpeg,.png,.pdf">
                    <p class="mt-1 text-sm text-gray-500">JPG, PNG, PDF (Max: 2MB)</p>
                    @error('receipt')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Trip Purpose -->
                <div class="md:col-span-2">
                    <label for="trip_purpose" class="block text-sm font-medium text-gray-700">Trip Purpose *</label>
                    <textarea name="trip_purpose" id="trip_purpose" rows="3" required
                              class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm p-2 focus:ring-blue-500 focus:border-blue-500"
                              placeholder="Describe the purpose of this trip...">{{ old('trip_purpose') }}</textarea>
                    @error('trip_purpose')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <div class="mt-6 flex justify-end space-x-3">
                <a href="{{ route('vehicle-usage.index') }}" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400">
                    Cancel
                </a>
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 flex items-center">
                    <i class="fas fa-save mr-2"></i> Save Record
                </button>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const vehicleSelect = document.getElementById('vehicle_id');
    const startKmInput = document.getElementById('start_km');
    
    vehicleSelect.addEventListener('change', function() {
        const selectedOption = vehicleSelect.options[vehicleSelect.selectedIndex];
        const currentKm = selectedOption.getAttribute('data-current-km');
        
        if (currentKm && startKmInput) {
            startKmInput.value = parseFloat(currentKm);
        }
    });
});
vehicleSelect.addEventListener('change', function() {
    const vehicleId = this.value;
    
    if (vehicleId) {
        fetch(`/vehicles/${vehicleId}/current-km`)
            .then(response => response.json())
            .then(data => {
                if (data.current_km) {
                    startKmInput.value = data.current_km;
                }
            })
            .catch(error => console.error('Error:', error));
    }
});
</script>
@endsection