@extends('layouts.app')

@section('title', 'Time Sheet Details- Canindigo INC')
@section('page-title', 'Time Sheet Details')

@section('content')
<div class="max-w-3xl mx-auto">
    <div class="bg-white rounded-lg shadow p-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <h4 class="text-sm font-medium text-gray-500">Date</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900">{{ $timeSheet->date->format('F d, Y') }}</p>
                <p class="text-sm text-gray-500">{{ $timeSheet->date->format('l') }}</p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Project Code</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900">{{ $timeSheet->project_code }}</p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Time</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900">
                    {{ date('g:i A', strtotime($timeSheet->start_time)) }} - {{ date('g:i A', strtotime($timeSheet->end_time)) }}
                </p>
                <p class="text-sm text-gray-500">Total: {{ $timeSheet->total_hours }} hours</p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Overtime Weekdays</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900">{{ $timeSheet->overtime_weekdays }} hours</p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Overtime Weekend</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900">{{ $timeSheet->overtime_weekend }} hours</p>
            </div>

            @if($timeSheet->description)
            <div class="md:col-span-2">
                <h4 class="text-sm font-medium text-gray-500">Description</h4>
                <p class="mt-1 text-gray-900">{{ $timeSheet->description }}</p>
            </div>
            @endif
        </div>

        <div class="mt-6 flex justify-end space-x-3">
            <a href="{{ route('time-sheets.index') }}" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400">
                Back to List
            </a>
            <!-- <a href="{{ route('time-sheets.edit', $timeSheet) }}" class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700">
                Edit Entry
            </a> -->
        </div>
    </div>
</div>
@endsection