@extends('layouts.app')

@section('title', 'Expense Claims- Canindigo INC')

@section('content')
<div class="bg-white rounded-lg shadow">
    <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
        <h3 class="text-lg font-medium text-gray-900">Expense Claims</h3>
        <a href="{{ route('expenses.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 flex items-center">
            <i class="fas fa-plus mr-2"></i>Add New Expense
        </a>
    </div>
    <div class="mt-2 grid grid-cols-1 md:grid-cols-4 gap-4">
        <div class="bg-blue-50 p-4 rounded-lg">
            <p class="text-sm font-medium text-blue-800">Total Expenses All Time</p>
            <p class="text-2xl font-bold text-blue-900">{{ number_format($totalAmount, 2) }}-OMR</p>
        </div>
        <div class="bg-green-50 p-4 rounded-lg">
            <p class="text-sm font-medium text-green-800">Total Approved</p>
            <p class="text-2xl font-bold text-green-900">{{ number_format($totalApproved, 2) }}-OMR</p>
        </div>
        <div class="bg-red-50 p-4 rounded-lg">
            <p class="text-sm font-medium text-red-800">Total Rejected</p>
            <p class="text-2xl font-bold text-red-900">{{ number_format($totalRejected, 2) }}-OMR</p>
        </div>
        <div class="bg-gray-50 p-4 rounded-lg">
            <p class="text-sm font-medium text-gray-800">Total Pending</p>
            <p class="text-2xl font-bold text-gray-900">{{ number_format($totalPending, 2) }}-OMR</p>
        </div>
    </div>
    
    <div class="p-6">
        @if(session('success'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">{{ session('success') }}</div>
        @endif

        @if($expenses->isEmpty())
            <div class="text-center py-8">
                <p class="text-gray-500 text-lg">No expense claims found.</p>
                <a href="{{ route('expenses.create') }}" class="mt-4 inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-white hover:bg-blue-700">Submit Your Claim</a>
            </div>
        @else
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Category</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Client Site</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($expenses as $expense)
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900">{{ $expense->expense_date->format('M d, Y') }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900">{{ $expense->description }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900">{{ $expense->category->name }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900">{{ number_format($expense->amount, 2) }}-OMR</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900">{{ $expense->clientSite->name }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="badge 
                                    @if($expense->status == 'approved') badge-success
                                    @elseif($expense->status == 'rejected') badge-danger
                                    @else badge-warning @endif">
                                    <div class="text-sm font-medium text-gray-900">{{ ucfirst($expense->status) }}</div>
                                    
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <a href="{{ route('expenses.show', $expense) }}" class="btn btn-sm btn-info">
                                    <i class="fas fa-eye"></i>
                                </a>
                                @if($expense->receipt_path)
                                <a href="{{ route('expenses.download-receipt', $expense) }}" class="btn btn-sm btn-secondary">
                                    <i class="fas fa-download"></i>
                                </a>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif
    </div>
</div>
@endsection