<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class HashExistingPasswordsSeeder extends Seeder
{
    public function run(): void
    {
        $users = User::all();
        
        foreach ($users as $user) {
            // Check if password is not already hashed
            if (!empty($user->password) && !preg_match('/^\$2y\$.{56}$/', $user->password)) {
                $user->password = Hash::make($user->password);
                $user->save();
            }
        }
        
        $this->command->info('All existing passwords have been hashed with Bcrypt.');
    }
}