<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VehicleUsage extends Model
{
    use HasFactory;

    protected $fillable = [
        'vehicle_id',
        'date',
        'start_km',
        'end_km',
        'fuel_consumption',
        'trip_purpose',
        'receipt_path',
        'user_id'
    ];

    protected $casts = [
        'date' => 'date',
        'start_km' => 'decimal:2',
        'end_km' => 'decimal:2',
        'fuel_consumption' => 'decimal:2',
    ];

    // Relationship with vehicle
    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }

    // Relationship with user
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Calculate distance traveled
    public function getDistanceAttribute()
    {
        return $this->end_km - $this->start_km;
    }

    // Calculate fuel efficiency
    public function getFuelEfficiencyAttribute()
    {
        if ($this->fuel_consumption > 0) {
            return $this->distance / $this->fuel_consumption;
        }
        return 0;
    }
}