<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Vehicle extends Model
{
    use HasFactory;

    protected $fillable = [
        'registration_number',
        'vehicle_type',
        'model',
        'color',
        'current_km',
        'status'
    ];

    // Relationship with vehicle usages
    public function vehicleUsages()
    {
        return $this->hasMany(VehicleUsage::class);
    }

    // Scope for active vehicles
    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }
}